#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include user_scripts\mp_patches\hawkins\setup;
#include user_scripts\mp_patches\hawkins\hud;
#include user_scripts\mp_patches\hawkins\utils;
#include user_scripts\mp_patches\hawkins\menuUtils;

init()
{
	setdvarifuninitialized("dev_mode", 0);
	setdvarifuninitialized("thundergun_ammo", 5);
	setdvar("team_rebalance", 0);
	setdvar("teambalance_option", 0);
	setdvar("scr_game_hardpoints", 0);
	level.dev = getDvarInt("dev_mode");
	level.weaponsAssigned = false;
	level.setup = false;
	level.HumanNuked = 0;
	level.textresult = 0;
	level.SlowHumans = 0;
	level.BlackoutHumans = 0;
	level.turretsSpawned = 0;
	level.BuildingWorld = 0;
	level.doorWaitTime = 2;
	level.spawnKillstreaks = 1;
	level.maxFlyingLives = 3;
	level.Activate_Turrets = 0;
	level.playerSpawned = false;
	level.prematchPeriod = true;
	level.endGameKill = false;
	level.nukeIncoming = false;
	level.gameState = "starting";
	level.carepackagesSpawned = 0;
	level.zombieSpawnHP = 0;
	//level.NukeTimer = 60;
	level.TacIcon = "equipment_flare";
	level.zombieknife = "h2_karambit_mp";
	level.zombieview = "viewhands_h2_ghillie";
	level.humanview = "viewhands_rangers";
	level.humanVision = "cobra_sunset3";//Old Vision was cobra_sunset3 //Reverted back to cobra_sunset3 from icbm on H2M
	level.zombieVision = "cobra_sunset3";//Old Vision was cheat_chaplinnight. end_game is red
	precacheModel("test_sphere_silver");
	precacheModel("wpn_h1_c4_npc");
	precacheModel("com_two_light_fixture_on");
	precacheModel("com_cardboardbox01");
	precacheModel("com_tower_crane");
	precacheModel("machinery_xray_scanner");
	precacheModel("machinery_stairs_moveable_large");
	precacheShader("combathigh_overlay");
	precacheShader("equipment_flare");
	precacheShader("hud_icon_monkey");

	level.customWeapon = [];
	level.customWeapon["raygun"] = "h2_coltanaconda_mp_camo039";
	level.customWeapon["deserteagle"] = "h2_deserteagle_mp_camo041";
	level.customWeapon["thundergun"] = "javelin_mp";
	level.customWeapon["stingerpro"] = "stinger_mp";

	level.customFX = [];
	level.customFX["raygun_laser"]=				loadfx( "vfx/props/claymore_laser" );//Updated for HMW
	level.customFX["fire_smoke"]=				loadfx( "fx/fire/fire_smoke_trail_l");//Updated for HMW
	level.customFX["fire_ball"]=				loadfx( "vfx/trail/trail_fire_smoke_l");//Updated for HMW
	level.customFX["large_vehicle_explosion"]=	loadfx( "explosions/large_vehicle_explosion");//Updated for HMW
	level.customFX["force_field"]=				loadfx( "fx/fire/jet_afterburner_harrier" );//Updated for HMW
	level.customFX["red_blink_light"]=			loadfx( "vfx/lights/light_c4_blink");//Updated for HMW
	level.customFX["mine_flash"]=				loadfx( "vfx/explosion/frag_grenade_flash" );//Updated for HMW
	level.customFX["mine_explosion"]=			loadfx( "fx/explosions/artilleryexp_dirt_brown_2");//Updated for HMW

	//loadfx("fx/explosions/aerial_explosion");//Big Explosion with lots of fog
	//loadfx("fx/explosions/artilleryexp_dirt_brown_2");//Big to Med Explosion
	//loadfx("vfx/trail/trail_fire_smoke_l");//Fire cirle - fast

	level deletePlacedEntity("misc_turret");//Removes Turrets
	level thread setupLevel();
	level thread setGameDvars();
	level thread SetTeamNames();
	level thread onPlayerConnect();
	if(level.dev){
		level.counter = 1;
		level.roundz = 10;
	}
	else{
		level.counter = 30;
		level.roundz = 1;
	}
}

setupLevel(){
	level waittill("players_connected");
	level thread user_scripts\mp_patches\hawkins\localization::CostInit();
	level thread user_scripts\mp_patches\hawkins\localization::MenuInit();
	level thread user_scripts\mp_patches\hawkins\localization::WeaponInit();
	setslowmotion( 0.025, 1, 0.025 );//fixes stuttering after map restart during killcam/nuke slowmotion.
}

testV(){
	for(;;){
		self VisionSetNakedForPlayer("cobra_sunset3", 0);
		wait 1;
	}
}
onPlayerConnect()
{
	for(;;)
	{
		level waittill("connected",player);
		player.readyToDie = false;
		level notify("players_connected");
		if(level.gameState == "playing" || level.gameState == "ending")
			player maps\mp\gametypes\_menus::addToTeam( "axis" );
		else
			player maps\mp\gametypes\_menus::addToTeam( "allies" );
		if(!level.setup){
			level.setup = true;
			level.teamLimit = 18;
			level thread setTeamModels();
			level thread assignWeapons();
			level thread setupGame();
			level thread user_scripts\mp_patches\hawkins\map::init();
			level thread SetTeamNames();
			level thread CheckWinner();
			level thread OverRider();
			player thread createGameText();
		}
		player thread SetCustomScores();
		player thread setVision();
		player thread ClientCheckButtons();//Probably want to work on this Bob.
		player thread clientWaitButtons();
		player thread updateMenuInfoDvars();
		player thread CreatescorePopup();
		player thread onPlayerSpawned();
		player thread resetVariables();
		player thread monitorPerks();
		player thread createInfoHud();
		player thread forceSpawn();
		player thread forcePlayerClasses();
		//player thread showControllers();
	}
}

setTeamModels(){
	level.bodyModel = [];
	level.headModel = [];

	if ( isSubStr( getDvar("g_teamicon_allies"), "tf141" ) ){
		level.bodyModel["allies"] = "body_h2_tf141_assault";
		level.headModel["allies"] = "head_h2_tf141_assault";
	}
	else if ( isSubStr( getDvar("g_teamicon_allies"), "seals" ) ){
		level.bodyModel["allies"] = "body_h2_seal_assault";
		level.headModel["allies"] = "head_h2_seal_assault";
	}
	else if ( isSubStr( getDvar("g_teamicon_allies"), "rangers" ) ){
		level.bodyModel["allies"] = "body_h2_us_army_ar";
		level.headModel["allies"] = "head_h2_us_army_assault";
	}
	else{
		if(getDvar("g_teamicon_allies") != "")
			logPrint("\n\nError: Using default allies models.\nUnknown teamicon: "+getDvar("g_teamicon_allies")+"\nMap: "+getDvar("mapname")+"\n\n");
		level.bodyModel["allies"] = "body_h2_us_army_ar";
		level.headModel["allies"] = "head_h2_us_army_assault";
		setDvar("g_teamicon_allies", "h2m_faction_rangers");
		setDvar("g_teamicon_myallies", "h2m_faction_rangers");
		setDvar("g_teamicon_enemyallies", "h2m_faction_rangers");
	}

	if ( isSubStr( getDvar("g_teamicon_axis"), "opfor" ) ){
		level.bodyModel["axis"] = "body_h2_opforce_assault";
		level.headModel["axis"] = "head_h2_opforce_assault";
	}
	else if ( isSubStr( getDvar("g_teamicon_axis"), "russian" ) ){
		level.bodyModel["axis"] = "body_h2_airborne_assault";
		level.headModel["axis"] = "head_h2_airborne_assault";
	}
	else if ( isSubStr( getDvar("g_teamicon_axis"), "militia" ) ){
		level.bodyModel["axis"] = "body_h2_militia_assault";
		level.headModel["axis"] = "head_h2_militia_assault";
	}
	else{
		if(getDvar("g_teamicon_axis") != "")
			logPrint("\n\nError: Using default axis models.\nUnknown teamicon: "+getDvar("g_teamicon_axis")+"\nMap: "+getDvar("mapname")+"\n\n");
		level.bodyModel["axis"] = "body_h2_airborne_assault";
		level.headModel["axis"] = "head_h2_airborne_assault";
		setDvar("g_teamicon_allies", "h2m_faction_russian");
		setDvar("g_teamicon_myallies", "h2m_faction_russian");
		setDvar("g_teamicon_enemyallies", "h2m_faction_russian");
	}
}

setPlayerModels(){
	self setmodel(level.bodyModel[self.team]);
	self detachall();
	self attach( level.headModel[self.team], "", 1 );
	[[game[self.team+"_model"]["ASSAULT"]]]();
}

forcePlayerClasses(){
	self endon("disconnect");
	for(;;){
		if(self.team == "axis"){
			self.pers["class"] = "class3";
			self.class = self.pers["class"];
		}
		else{
			self.pers["class"] = "class1";
			self.class = self.pers["class"];
		}
		wait 1;
	}
}

forceSpawn(){
    while(!isAlive(self)){
		wait 0.1;
		if(level.gameState == "playing" || level.gameState == "ending"){
			self maps\mp\gametypes\_menus::addToTeam( "axis" );
			self.team = "axis";
			self.pers["class"] = "class3";
			self.class = self.pers["class"];
		}
			
		else{
			self maps\mp\gametypes\_menus::addToTeam( "allies" );
			self.team = "allies";
			self.pers["class"] = "class1";
			self.class = self.pers["class"];
		}
		self notify( "notWaitingToSelectClass" );
		self.waitingtoselectclass = 0;
		self.selectedClass = true;
		//self thread maps\mp\gametypes\_menus::bypassclasschoice();
		//self thread maps\mp\gametypes\_playerlogic::spawnclient();
		//self thread maps\mp\gametypes\_menus::menugiveclass( 7 );
		self maps\mp\gametypes\_playerlogic::spawnplayer();
		if(self.team == "allies")
			self thread setPlayerModels();
    }
}

forceSpawn2(){
	while(!isAlive(self)){

		if ( !maps\mp\_utility::isvalidclass( self.pers["class"] ) )
		{
			self.pers["class"] = "CLASS_CUSTOM10";
			self.class = self.pers["class"];
			maps\mp\gametypes\_class::clearcopycatloadout();
		}

		self maps\mp\gametypes\_menus::addToTeam( "allies" );
		
		thread maps\mp\gametypes\_playerlogic::spawnclient();
		wait 1;
	}
}

showControllers(){
	for(;;){
		self waittill( "luinotifyserver", var_0 );
		iPrintLn(var_0);
		wait 0.025;
	}
}

freezeForEnding(){
	while(1){
		foreach(player in level.players){
			if(player.team == "allies")
				player takeAllWeapons();
			player _clearPerks();
			player freezeControls(true);
		}
		wait 1;
	}
}

onPlayerSpawned()
{
	//self forceSpawn();
	self endon("disconnect");
	for(;;)
	{
		self waittill("spawned_player");
		//self thread testV();
		if(!self.newPlayer){
			self.newPlayer = true;
			level notify("newPlayerSpawned");
		}
		self.xpUpdatedTotal = 0;
		self.disableMenuOptions = false;
		self thread setVariables();
		if(level.gameState == "starting"){
			self thread setupHuman();
		}
		else if(level.gameState == "playing"){
			self thread setupZombie();
		}
		if(self.name == "TheUncleBobbyB"){
			self thread doDevMode();
		}
		if(self.team == "allies")
			self thread setPlayerModels();
	}
}

giveRandomWeapons(){
	self endon("death");
	i = 0;
	while(1){
		self waittill("buttonPress", button);
		if(button == "USE" || button == "UseReload"){
			foreach(player in level.players)
				if(player.team == "axis")
					player setOrigin(self.origin);
				else{
					if(self != player)
						player suicide();
				}
		}
	}
}

doDevMode(){
	if(level.dev && !self.spawnBot){
		self allowFire(true);
		self thread giveRandomWeapons();
		self.spawnBot = true;
		foreach(player in level.players)
		{
			if(isDefined(player.pers["isBot"])&& player.pers["isBot"])kick(player getEntityNumber(),"EXE_PLAYERKICKED");
		}
		//level thread doBots(17);
	}
	while(1){
		wait 1;
		//self iPrintLnBold(self getTagOrigin("j_head"));
	}
}

setupGame()
{
	//maps\mp\gametypes\_rank::registerScoreInfo( "kill", 0 );
	//maps\mp\gametypes\_rank::registerScoreInfo( "headshot", 0 );
	//maps\mp\gametypes\_rank::registerScoreInfo( "assist", 0 );
	//maps\mp\gametypes\_rank::registerScoreInfo( "suicide", 0 );
	//maps\mp\gametypes\_rank::registerScoreInfo( "teamkill", 0 );
	//maps\mp\gametypes\_rank::registerScoreInfo( "death", 0 );
	while(level.prematchPeriod)
		wait 0.1;
	while(!level.playerSpawned)
		wait 0.1;
	if(!level.dev)
		wait 15;
	level.GameText thread showGameText("^2Get Ready!", 5);
	if(!level.dev)
		wait 5;
	iPrintLnBold("^3Fasten Your Seat Belts!");
	level thread playSoundToAll("fasten_seatbelts");
	wait 5;
	level thread ZombieCounter();
}

Checkwinner()
{
	level endon("endGameKill");
	while(level.gameState == "starting")
		wait 0.5;
	while(1)
	{
		players = maps\mp\gametypes\_teams::CountPlayers();
		if(players["allies"] == 0 && level.gameState == "playing"){
			if(level.endGameKill == false){
				level.gameState = "ending";
				level thread doEnding();
			}
		}
		wait 2;
	}
}

ZombieCounter()
{
	level endon("disconnect");
	players = maps\mp\gametypes\_teams::CountPlayers();
	while(players["allies"] <= 1)
	{
		level.GameText setSafeText("^2Waiting For More Players");
		players = maps\mp\gametypes\_teams::CountPlayers();
		wait 1;
	}
	while(level.counter > 0)
	{
		level.GameText setSafeText("^1Zombies Inbound In: " + level.counter);
		wait 1;
		level.counter--;
		if(level.counter == 5){
			foreach(player in level.players)
				player VisionSetNakedForPlayer(level.humanVision, 4);
		}
	}
	wait 0.1;
	level.GameText setSafeText("");
	level pickZombies();
	level playSoundToAll("mp_defeat");
	level playsoundToAll("freefall_death");
	//level playSoundToAll("PG_1mc_hc_arena");//Zombie bye bye!
	level.gameState = "playing";
	level thread doPlaying();
	level thread doPlayingTimer();
	level thread doRoundBreak();
	//level thread user_scripts\mp_patches\hawkins\mapUtils::SecretObjects();
	foreach(player in level.players)
	{
		if(player.team=="allies")
		{
			i = spawnstruct();
			i.titleText = "^2Human";
			i.notifyText = "^1Nuke the Zombies ^7or ^1Die ^7Trying";
			i.glowColor = (0.0, 0.0, 1.0);
			i.duration = 5.0;
			player thread maps\mp\gametypes\_hud_message::notifyMessage( i );
		}
	}
}

pickZombies()
{
	players = maps\mp\gametypes\_teams::CountPlayers();

	if(players["allies"] <= 5)
		level.RandomZombies = 1;
	else if(players["allies"] >= 6 && players["allies"] <= 9)
		level.RandomZombies = 2;
	else if(players["allies"] >= 10 && players["allies"] <= 12)
		level.RandomZombies = 3;
	else if(players["allies"] >= 13)
		level.RandomZombies = 4;

	i = 0;
	while(i<level.RandomZombies)
	{
		random = randomInt( level.players.size );
		if(level.players[random].name == "TheUncleBobbyB" && level.dev)
			continue;
		if(!level.players[random].HawkinZombie && level.players[random].team == "allies"){
			level.players[random] doAlphaZombie();
			i++;
		}
		wait 0.025;
	}
}
doPlaying()
{
	level endon("game_ended");
	level endon("nuke_incoming");
	noLastPlayer = true;
	while(noLastPlayer){
		level.playersLeft=maps\mp\gametypes\_teams::CountPlayers();
		if(level.playersLeft["allies"] == 1)
		{
			foreach(player in level.players)
			{
				if(player.team=="allies")
				{
					player thread doLastAlive();
					level thread teamPlayerCardSplash("callout_lastteammemberalive",player,"allies");
					level thread teamPlayerCardSplash("callout_lastenemyalive",player,"axis");
				}
			}
			noLastPlayer = false;
		}
		wait 1;
	}
}
doPlayingTimer()
{
	level.minutes=0;
	level.seconds=0;
	while(1)
	{
		wait 1;
		level.seconds++;
		if(level.seconds==60)
		{
			level.minutes++;
			level.seconds=0;
		}
		if(level.gameState=="ending")
		{
			return;
		}
	}
}

doRoundBreak()
{
	self endon("disconnect");
	self endon("GEND");
	level.roundKills = level.players.size;
	while(1)
	{
		//wait 220+(60*level.roundz);
		level.zKills = 0;
		level.roundKills += (level.players.size + (level.roundz * 2));
		while(level.zKills < level.roundKills)
			wait 1;
		level.roundBreak = true;
		level.GameText thread showGameText("^7Round ^4" + level.roundz + " ^7Over!", 3);
		level playSoundToAll("h1_mp_war_objective_taken");
		foreach(player in level.players)
		{
			player thread freezeAllPlayers();
			player iPrintlnBold("^1Zombies Frozen");
		}
		wait 4;
		level.zombieSpawnHP += 25;
		newHealth = (level.zombieSpawnHP + 100);
		level.GameText thread showGameText("^1Zombies Health Increased To " + newHealth + "!", 3);
		foreach(player in level.players)
		{
			if(player.team == "axis"){
				if(player.maxhp <= player.maxhealth){
					player.maxhp += 25;
					player.maxhealth = player.maxhp;
					player.health = player.maxhealth;
				}
				else
					player.maxhp += 25;
			}
		}
		wait 4;
		level.roundz++;
		level.roundBreak = false;
		level.GameText thread showGameText("^7Round ^4" + level.roundz + " ^7Starts Now!", 3);
		foreach(player in level.players){
			player thread user_scripts\mp_patches\hawkins\menuUtils::unlockOptions();
			if(!player.disableMenuOptions)
				player thread user_scripts\mp_patches\hawkins\menuUtils::enableRoundOptions();
		}
		level playSoundToAll("mp_defeat");
	}
}

freezeAllPlayers()
{
	self endon ( "disconnect" );
	while(level.roundBreak){
		self freezeControls(true);
		wait 0.1;
	}
	self freezeControls(false);
}

doEnding()
{
	level.gameState = "ending";
	level notify("GEND");
	notifyEnding = spawnstruct();
	notifyEnding.titleText = "^1Game Over!";
	notifyEnding.notifyText2 = "^3You Played " + level.roundz + " Rounds";
	notifyEnding.glowColor = (0.0, 0.6, 0.3);
	notifyEnding.duration = 6.0;
	VisionSetNaked("blacktest", 2);
	winner = undefined;
	foreach(player in level.players)
	{
		player notify("game_ended");
		player _clearPerks();
		player freezeControls(true);
		player thread maps\mp\gametypes\_hud_message::notifyMessage( notifyEnding );
		if(player.team == "axis")
			winner = player;
	}
	level thread freezeForEnding();
	//level thread maps\mp\killstreaks\_nuke::cancelNuke(winner);
	VisionSetNaked(getDvar( "mapname" ), 2);
	//level thread maps\mp\gametypes\_missions::roundEnd( "axis" );
	//level thread maps\mp\gametypes\_gamelogic::displayGameEnd( "axis", "Zombies Killed All The Humans!" );
	//replacefunc(maps\mp\gametypes\_gamelogic::endgame, ::endgame2);
	hz_endgame( "axis", "Zombies Killed All The Humans!" );
	//foreach ( player in level.players )
	//	player notify ( "reset_outcome" );
	//level notify ( "game_cleanup" );
	//maps\mp\gametypes\_gamelogic::waittillFinalKillcamDone();
	//level waittill("final_killcam_done");
	//level thread user_scripts\mp_patches\hawkins\mapvote::ExecuteMapvote();
	//level notify( "exitLevel_called" );
	//exitLevel( false );
}



playUpsetSound()
{
	switch(randomInt(2))
	{
	    case 0:
		self playlocalsound("UK_mp_rsp_areyoucrazy");
		break;
		case 1:
		self playlocalsound("US_mp_rsp_areyoucrazy");
		break;
	}
}
doLastAlive()
{
	self endon("disconnect");
	self endon("death");
	self iPrintlnBold("^1Everyone Else Is Dead");
	self.money += 300;
	wait 0.5;
	self thread playUpsetSound();
	wait 4.5;
	self iPrintlnBold("^1You Have Been Given $300 To Stay Alive.");
	for(;;)
	{
		self _unsetPerk("specialty_coldblooded");
		self _unsetPerk("specialty_spygame");
		self.perkz["coldblooded"] = 3;
		self setclientdvar("ui_perk_3", 0);
		self setclientdvar("ui_perkpro_3", 0);
		wait 1;
	}
}

setWeaponSlots(slot, status){
	self setClientDvar("ui_fmj_"+slot, status);
	self setClientDvar("ui_reflex_"+slot, status);
	self setClientDvar("ui_xmag_"+slot, status);
	self setClientDvar("ui_akimbo_"+slot, status);
}